/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_tabs.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       16/Feb/2014
  
  * History:  16/Feb/2014- Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"
#include "mc_parameters.h"
#include "FSLtime.h"
// Image object
#include ".\Tabs\tabO.h"
#include ".\Tabs\Icons.h"
#include ".\Tabs\Gear.h"
#include ".\Tabs\seatBelt.h"
// Fonts
#include "ARIAL34.h"
#include "ARIAL30.h"



typedef struct {
    int16_t     start1;
    int16_t     stop1;
    int16_t     start2;
    int16_t     stop2;
    int16_t     vdlPos;
    uint32_t    colorStart;
    uint32_t    colorTarget;
    uint8_t     frames;
    int8_t      acc;
}ani3Data_t;

typedef struct
{
	uint8_t x;
	uint8_t y;
}SeatPos_t;

// ********  Constants  ************
const SeatPos_t SeatPos[5] = 
{
	{12,0},
	{36,0},
	{0,31},
	{24,31},
	{48,31}
};

const ani3Data_t ani3Data[6] = {
  {144, 557, -33, 158, 634, TABS_RED, TABS_ORANGE, 18, 6},
  {557, 612, 158, 570, 165, TABS_ORANGE, TABS_GREEN, 14, 6},
  {609, 800, 570, 626, 165, TABS_GREEN, TABS_BLUE, 8, 6},
  {557, 144, 158, -33, 634, TABS_ORANGE, TABS_RED, 18, -6},
  {609, 557, 570, 158, 634, TABS_GREEN, TABS_ORANGE, 14, -6},
  {800, 612, 626, 570, 165, TABS_BLUE, TABS_GREEN, 8, -6},
};

/********************/
/* Global Variables */
/********************/

uint8_t tabsMoving = 0;

// Graphics Objects           
Graphics_Object_t tabsLeft_RAM;
Graphics_Object_t tabsRight_RAM;
Graphics_Object_t tabsCenter_RAM;
Graphics_Object_t tabsLine_RAM;
Graphics_Object_t tabsVDL_RAM;
Graphics_Object_t tabsText_RAM =
{
    (uint32_t)NULL_PTR, 800, 50, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};

Graphics_Object_t tabsTempTime_RAM =
{
    (uint32_t)NULL_PTR, 120, 80, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};

Graphics_Object_t tabsTripOddo_RAM =
{
    (uint32_t)NULL_PTR, 200, 80, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};

Graphics_Object_t tabsSeatBelt_RAM =
{
    (uint32_t)0,72,62,NULL_PTR,0x00,0,GRAPHICS_565RGB,255,0xFF0000,0x0, (GRAPHICS_CODING_RAWINT),0,0,(void *)0
};
mc_tabs_parameters_t mc_tabs_parameters ={0};
mc_tabs_parameters_t mc_tabs_parameters_l = {0};
mc_global_parameters_t mc_global_tabs = {0};

uint8_t tabsState = 0;
uint16_t MediaStringLength = 0;
uint8_t sRange[3] ="234";
uint8_t sNavi[5] = "NAV";
uint8_t sMedia[30] ="Radio Freescale ABC DEF 123.5*";
uint8_t sClock[5] = "20:35";
uint8_t sTemp[6] = {'+','2','6','.','5',0};
uint8_t sKmTotal[9] = " 1234567";
uint8_t sKmTrip[9] = " 12345.6";
uint8_t *p_TextMedia = 0;
extern uint8_t bootState;
/*********************************/
/* Function prototypes ***********/
/*********************************/
void transitAnimation(uint8_t aniNo);
void transitAnimationB(uint8_t aniNo);
void setColorTabs(uint32_t color);
uint8_t ProcessRangeText(void);
uint8_t DrawRange(void);
uint8_t ProcessMediaText(void);
uint8_t DrawMedia(void);
uint8_t DrawMediaIcon(void);
uint8_t tabsPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
);
void setGear(void);
void SeatBeltUpdate(uint8_t seat, uint8_t value);
void CalculateTime(void);
uint8_t CalculateTemp(void);
uint8_t CalculateKmTotal(void);
uint8_t CalculateKmTrip(uint32_t);
/*******************************/
/*  Code starts Here           */
/*******************************/
void mc_tabs(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint32_t temp32;
    uint8_t dmachnl;
    Graphics_ErrorType Gret;
    
    if(mc_tabs_properties.frameLatch == 0u)
    {
        mc_tabs_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_tabs_properties.frameLatch;
    
// Init objects     
    switch(relative_fr)
    {
      // We start by initializing all the graphics objects by copy to RAM.
      // In a Halo device this is not necassary because we can just leave them in FLASH.
      case 0:
          mc_tabs_parameters_l.function = mc_tabs_parameters.function;
          mc_tabs_parameters_l.subFunction = mc_tabs_parameters.subFunction = 254;
        // Copy GO data to RAM GO
          Graphics_CopyGraphicObject(tabO_GObjectArray[0], &tabsVDL_RAM);
          Graphics_CopyGraphicObject(tabO_GObjectArray[1], &tabsLeft_RAM);
          Graphics_CopyGraphicObject(tabO_GObjectArray[2], &tabsLine_RAM);
          Graphics_CopyGraphicObject(tabO_GObjectArray[3], &tabsRight_RAM);
          Graphics_CopyGraphicObject(tabO_GObjectArray[4], &tabsCenter_RAM);
          // Set address of RAM GO in statically allocated RAM
          // RAM size and pointer defined in mc_parameters.h
          temp32 = (uint32_t)p_tabsSAM;
          //addr for Layer needs to be 64byte aligned
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsVDL_RAM.address = temp32;
          temp32 += tabsVDL_RAM.width * tabsVDL_RAM.height;  //
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsLeft_RAM.address = temp32;
          temp32 += tabsLeft_RAM.width * tabsLeft_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsLine_RAM.address = temp32;
          temp32 += tabsLine_RAM.width * tabsLine_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsRight_RAM.address = temp32;
          temp32 += tabsRight_RAM.width * tabsRight_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsCenter_RAM.address = temp32;
          temp32 += tabsCenter_RAM.width * tabsCenter_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsText_RAM.address = temp32;
          temp32 += tabsText_RAM.width * tabsText_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsTempTime_RAM.address = temp32;
          temp32 += tabsTempTime_RAM.width * tabsTempTime_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsTripOddo_RAM.address = temp32;
          temp32 += tabsTripOddo_RAM.width * tabsTripOddo_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          tabsSeatBelt_RAM.address = temp32;
          temp32 += tabsSeatBelt_RAM.width * tabsSeatBelt_RAM.height;
          if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
          
          
          // Copy object data from FLASH to RAM, 1 / frame to not block all DMA ch's
          dmachnl = DMAHR_GetNextFreeChannel();
          if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
          else Graphics_Paste(dmachnl, tabO_GObjectArray[0], &tabsVDL_RAM, 0, 0, NULL_PTR);
      break;    
      case 1:
          dmachnl = DMAHR_GetNextFreeChannel();
          // if there is no free DMA channel adjust the mc frame counter to do this again 
          if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
          else Graphics_Paste(dmachnl, tabO_GObjectArray[1], &tabsLeft_RAM, 0, 0, NULL_PTR);
      break;    
      case 2:
          dmachnl = DMAHR_GetNextFreeChannel();
          // if there is no free DMA channel adjust the mc frame counter to do this again 
          if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
          else Graphics_Paste(dmachnl, tabO_GObjectArray[2], &tabsLine_RAM, 0, 0, NULL_PTR);
      break;    
      case 3:
          dmachnl = DMAHR_GetNextFreeChannel();
          // if there is no free DMA channel adjust the mc frame counter to do this again 
          if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
          else Graphics_Paste(dmachnl, tabO_GObjectArray[3], &tabsRight_RAM, 0, 0, NULL_PTR);
      break;
      case 4:
          dmachnl = DMAHR_GetNextFreeChannel();
          // if there is no free DMA channel adjust the mc frame counter to do this again 
          if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
          else Graphics_Paste(dmachnl, tabO_GObjectArray[4], &tabsCenter_RAM, 0, 0, NULL_PTR);
      break;   
      case 5:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else    Graphics_BlankArea(dmachnl, &tabsText_RAM, 0x00000000, NULL_PTR);
      break;
      case 6:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++; 
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[7],  //FuelPump 
              &tabsText_RAM,
              40,
              11,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
		break;
	  case 7:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[3], //km
              &tabsText_RAM,
              125,
              24,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
      break;
      case 8:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[8],  //Radio 
              &tabsText_RAM,
              293,
              9,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
		break;
		case 9:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[6], //phone
              &tabsText_RAM,
              589,
              19,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
      break;      
      case 10:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[5],  //NaviGlobe 
              &tabsText_RAM,
              657,
              8,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
      break;
      case 11:
        ProcessRangeText();
        DrawRange();
      break;
      case 12:
        tabsPrint(&tabsText_RAM, (char*) sNavi, (Font_FontType*)&ARIAL30_Font,695, 12, FONT_LEFT, 0, 3); 
      break;
// Bottom info area init      
      case 13:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else    Graphics_BlankArea(dmachnl, &tabsTripOddo_RAM, 0x00000000, NULL_PTR);
      break;
      case 14:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else    Graphics_BlankArea(dmachnl, &tabsTempTime_RAM, 0x00000000, NULL_PTR);
      break;
      case 15:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else    Graphics_BlankArea(dmachnl, &tabsSeatBelt_RAM, 0x00000000, NULL_PTR);
      break;
      case 16:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[3], //km 
              &tabsTripOddo_RAM,
              176,
              57,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
		break;
	case 17:	
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_tabs_properties.frameLatch++;
        else{
            Gret = Graphics_Paste(
              dmachnl,
              Icons_GObjectArray[3], //km
              &tabsTripOddo_RAM,
              176,
              17,
              NULL_PTR);
            if (Gret != GRAPHICS_ERROR_OK) while(1); //:TODO if something unexpected and bad happens just stop here. Just for debug needs to be removed
        }
      break;
      case 18:
// top tabs layer init       
          Display_InitLayer(TABS_CENTER_LAYER,&tabsCenter_RAM, 0, 58);
          DCU_TileMode(TABS_CENTER_LAYER, 1, 16, 50);
          DCU_LayerSetWidth(TABS_CENTER_LAYER, 160 );
          DCU_ForeGroundColor(TABS_CENTER_LAYER) = TABS_RED;
          DCU_BackGroundColor(TABS_CENTER_LAYER) = 0x0;
          DCU_LayerAlphaCfg(TABS_CENTER_LAYER) = 0;

          Display_InitLayer(TABS_RIGHT_LAYER,&tabsRight_RAM, 144, 58);
          DCU_ForeGroundColor(TABS_RIGHT_LAYER) = TABS_RED;
          DCU_BackGroundColor(TABS_RIGHT_LAYER) = 0x0;
          DCU_LayerAlphaCfg(TABS_RIGHT_LAYER) = 0;

          Display_InitLayer(TABS_LEFT_LAYER,&tabsLeft_RAM, -32, 58);
          DCU_ForeGroundColor(TABS_LEFT_LAYER) = TABS_RED;
          DCU_BackGroundColor(TABS_LEFT_LAYER) = 0x0;
          DCU_LayerAlphaCfg(TABS_LEFT_LAYER) = 0;

          Display_InitLayer(TABS_LINE_LAYER,&tabsLine_RAM, 0, 104);
          DCU_TileMode(TABS_LINE_LAYER, 1, 16, 4);
          DCU_LayerSetWidth(TABS_LINE_LAYER, 800 );
          DCU_LayerSetHeight(TABS_LINE_LAYER, 4);
          DCU_ForeGroundColor(TABS_LINE_LAYER) = TABS_RED;
          DCU_BackGroundColor(TABS_LINE_LAYER) = 0x0;
          DCU_LayerAlphaCfg(TABS_LINE_LAYER) = 0;
          
          Display_InitLayer(TABS_VDL_LAYER,&tabsVDL_RAM, 577, 66);
          DCU_ForeGroundColor(TABS_VDL_LAYER) = TABS_RED;
          DCU_BackGroundColor(TABS_VDL_LAYER) = 0x0;
          DCU_LayerAlphaCfg(TABS_VDL_LAYER) = 0;
          
          Display_InitLayer(TABS_VDL_LAYER2,&tabsVDL_RAM, 630, 67);
          DCU_ForeGroundColor(TABS_VDL_LAYER2) = TABS_RED;
          DCU_BackGroundColor(TABS_VDL_LAYER2) = 0x0;
          DCU_LayerAlphaCfg(TABS_VDL_LAYER2) = 2;

          Display_InitLayer(TABS_TEXT_LAYER,&tabsText_RAM, 0, 58);
          DCU_ForeGroundColor(TABS_TEXT_LAYER) = 0xFFFFFF;
          DCU_BackGroundColor(TABS_TEXT_LAYER) = 0x0;
          DCU_LayerAlphaCfg(TABS_TEXT_LAYER) = 2;
          DCU_LayerChromaCfg(TABS_TEXT_LAYER) = 1;
          mc_tabs_parameters.mmText = mc_tabs_parameters_l.mmText = sMedia;
          mc_tabs_parameters.mmTextCount = mc_tabs_parameters_l.mmTextCount = 30;
// Bottom info layer init
          Display_InitLayer(TABS_LINE_LAYER2,&tabsLine_RAM, 160, 397);
          DCU_TileMode(TABS_LINE_LAYER2, 1, 16, 4);
          DCU_LayerSetWidth(TABS_LINE_LAYER2, 480 );
          DCU_LayerSetHeight(TABS_LINE_LAYER2, 3);
          DCU_ForeGroundColor(TABS_LINE_LAYER2) = 0xFFFFFF;
          DCU_BackGroundColor(TABS_LINE_LAYER2) = 0x0;
          DCU_LayerAlphaCfg(TABS_LINE_LAYER2) = 0;
          
          Display_InitLayer(TABS_TEMPTIME_LAYER,&tabsTempTime_RAM,162,397);
          DCU_LayerAlphaCfg(TABS_TEMPTIME_LAYER) = 2;
          DCU_LayerChromaCfg(TABS_TEMPTIME_LAYER) = 1;
          Display_FGColor(TABS_TEMPTIME_LAYER) = 0xFFFFFFFF;
          Display_BGColor(TABS_TEMPTIME_LAYER) = 0x0;

          Display_InitLayer(TABS_TRIPODDO_LAYER,&tabsTripOddo_RAM,430,397);
          DCU_LayerAlphaCfg(TABS_TRIPODDO_LAYER) = 2;
          DCU_LayerChromaCfg(TABS_TRIPODDO_LAYER) = 1;
          Display_FGColor(TABS_TRIPODDO_LAYER) = 0xFFFFFFFF;
          Display_BGColor(TABS_TRIPODDO_LAYER) = 0x0;

          Display_InitLayer(TABS_GEAR_LAYER,Gear_GObjectArray[0],368,403);
          DCU_LayerSetHeight(TABS_GEAR_LAYER, 38);
          DCU_LayerAlphaCfg(TABS_GEAR_LAYER) = 2;
          DCU_LayerChromaCfg(TABS_GEAR_LAYER) = 1;
          Display_FGColor(TABS_GEAR_LAYER) = 0xFFFFFFFF;
          Display_BGColor(TABS_GEAR_LAYER) = 0x0;
          
          Display_InitLayer(TABS_SEATBELT_LAYER,&tabsSeatBelt_RAM,295,410);
          DCU_LayerAlphaCfg(TABS_SEATBELT_LAYER) = 0;
          DCU_LayerChromaCfg(TABS_SEATBELT_LAYER) = 0;
          mc_tabs_parameters.time.h = 12;
          mc_tabs_parameters.time.m = 22;
          mc_tabs_parameters.oddo = 23;
          mc_tabs_parameters.trip1 = 160;
          mc_tabs_parameters.temp = 203;
          mc_tabs_parameters.mmTextUpdate = 1;
          mc_global_parameters.range = 786;
          mc_stage_tc_properties.run = 1u;
      break;
      case 19:
        //if (bootState == 1){
          //mc_stage_tc_properties.run = 1;
          //bootState = 2;
        //}
      break;  
      default:
        
      break;
    }
/**************************************************************************************************************************/
// Init objects END *******************************************************************************************************************************
/**************************************************************************************************************************/    
    if (relative_fr > 22){
// Tabs Parameter logic      
          
        //Restricted 6Hz and only one text string update at a time to not load the QuadSPI FLASH
          // e.g. we do this only every 10th frame and since the check is "else if". we only do 1 of them at a time.
          if (!(relative_fr % 10)){
            //Check if time changed and if it did, redraw it.
            if ((mc_tabs_parameters_l.time.h != mc_tabs_parameters.time.h) || 
                (mc_tabs_parameters_l.time.m != mc_tabs_parameters.time.m)){
                  CalculateTime();
                  if ((tabsPrint(&tabsTempTime_RAM, (char*) sClock, (Font_FontType*)&ARIAL34_Font,-24, 42, FONT_RIGHT, 0, 5)) == 0) {
                    mc_tabs_parameters_l.time.h = mc_tabs_parameters.time.h;
                    mc_tabs_parameters_l.time.m = mc_tabs_parameters.time.m;
                }
            }
            //Check if temp changed and if it did, redraw it.
            else if(mc_tabs_parameters_l.temp != mc_tabs_parameters.temp){
                if ((tabsPrint(&tabsTempTime_RAM, (char*) sTemp, (Font_FontType*)&ARIAL34_Font,-24, 2, FONT_RIGHT, 0, CalculateTemp())) == 0){
                    mc_tabs_parameters_l.temp = mc_tabs_parameters.temp;
                }            
            }
            else if (mc_tabs_parameters_l.oddo != mc_tabs_parameters.oddo){
              //Check if Oddometer changed and if it did, redraw it.
                if ((tabsPrint(&tabsTripOddo_RAM, (char*) sKmTotal, (Font_FontType*)&ARIAL34_Font,-29, 42, FONT_RIGHT, 0, CalculateKmTotal())) == 0){
                    mc_tabs_parameters_l.oddo = mc_tabs_parameters.oddo;
                }            
            } 
            else if (mc_tabs_parameters_l.trip1 != mc_tabs_parameters.trip1){
              //Check if Oddometer changed and if it did, redraw it.
                if ((tabsPrint(&tabsTripOddo_RAM, (char*) sKmTrip, (Font_FontType*)&ARIAL34_Font,-29, 2, FONT_RIGHT, 0, CalculateKmTrip(mc_tabs_parameters.trip1))) == 0){
                    mc_tabs_parameters_l.trip1 = mc_tabs_parameters.trip1;
                }            
            } 
         }   
      if (mc_tabs_parameters_l.function != mc_tabs_parameters.function){
        //trying to be the less intrusive as possible, IM
        uint8_t function_change = mc_tabs_parameters_l.function;
        //end IM mods
        switch (tabsState){
          case 0: //"Range" tab pos
            tabsState = 1; // transitioning from "range" to "multiMedia" enable
            transitAnimationB(0);
          break;
          case 1: // transitioning "range" to "multiMedia"
            if (tabsMoving) transitAnimationB(0);
            else {
              tabsState = 2;
              if (mc_tabs_parameters_l.function > mc_tabs_parameters.function)
                      mc_tabs_parameters_l.function--;
              else mc_tabs_parameters_l.function++;
            }
          break;
          case 2: // "multimedia" tab pos ****************
            //check direction
            if (mc_tabs_parameters.function < mc_tabs_parameters_l.function){
              tabsState = 3; // transitioning from "MultiMedia" to "range"
              transitAnimationB(3);
            }
            else {
              tabsState = 4; // transitioning from "MultiMedia" to "phone"
              transitAnimationB(1);
            }
          break;
          case 3: // transitioning "MultiMedia" to "range"
            if (tabsMoving) transitAnimationB(3);
            else {
              tabsState = 0;
              if (mc_tabs_parameters_l.function > mc_tabs_parameters.function)
                      mc_tabs_parameters_l.function--;
              else mc_tabs_parameters_l.function++;
            }
          break;
          case 4: // transitioning "MultiMedia" to "range"
            if (tabsMoving) transitAnimationB(1);
            else {
              tabsState = 5;
              if (mc_tabs_parameters_l.function > mc_tabs_parameters.function)
                      mc_tabs_parameters_l.function--;
              else mc_tabs_parameters_l.function++;
            }
          break;
          case 5: // "phone" tab pos ******************
            //check direction
            if (mc_tabs_parameters.function < mc_tabs_parameters_l.function){
              tabsState = 6; // transitioning from "MultiMedia" to "range"
              transitAnimationB(4);
            }
            else {
              tabsState = 7; // transitioning from "phone" to "navi"
              transitAnimationB(2);
            }
          break;
          case 6: // transitioning "phone " to "MultiMedia"
            if (tabsMoving) transitAnimationB(4);
            else {
              tabsState = 2;
              if (mc_tabs_parameters_l.function > mc_tabs_parameters.function)
                      mc_tabs_parameters_l.function--;
              else mc_tabs_parameters_l.function++;
            }
          break;
          case 7: // transitioning "phone2 to "Navi"
            if (tabsMoving) transitAnimationB(2);
            else {
              tabsState = 8;
              if (mc_tabs_parameters_l.function > mc_tabs_parameters.function)
                      mc_tabs_parameters_l.function--;
              else mc_tabs_parameters_l.function++;
            }
          break;
          case 8: // "Navi" tab pos   ********************
            //check direction
            if (mc_tabs_parameters.function < mc_tabs_parameters_l.function){
              tabsState = 9; // transitioning from "MultiMedia" to "range"
              transitAnimationB(5);
            }
            else {
              //tabsState = 7; // transitioning from "MultiMedia" to "phone"
              //transitAnimationB(5);
              mc_tabs_parameters.function  = mc_tabs_parameters_l.function;
            }
          break;
          case 9: // transitioning "navi " to "phone"
            if (tabsMoving) transitAnimationB(5);
            else {
              tabsState = 5;
              if (mc_tabs_parameters_l.function > mc_tabs_parameters.function)
                      mc_tabs_parameters_l.function--;
              else mc_tabs_parameters_l.function++;
            }
          break;
        }// switch (tabsState) ...
        
        //B06623 launch movie clips
        if(function_change != mc_tabs_parameters_l.function)
        {
          //something changed, kill and run movieclips      
          if(function_change == 0) {
            mc_doors_properties.kill = 1; 
            mc_stage_tc_properties.kill = 1; 
          }
          if(function_change == 1) mc_cf_properties.kill = 1;
          if(function_change == 2) mc_base_properties.kill = 1;
          if(function_change == 3) mc_gps_properties.kill = 1;
          
          if(mc_tabs_parameters_l.function == 0) mc_tabs_parameters_l.subFunction = 255; //provoke change      
          if(mc_tabs_parameters_l.function == 1) mc_cf_properties.run = 1;
          if(mc_tabs_parameters_l.function == 2) mc_base_properties.run = 1;
          if(mc_tabs_parameters_l.function == 3) mc_gps_properties.run = 1;
        }
        //end B06623 launch movie clips
      }// if (mc_tabs_parameters_l.function != mc_tabs_parameters.function) ...
      
      //B06623 on this tab, we can have 2 different movie clips
      
      if(mc_tabs_parameters_l.function == 0)
      {
          //subfunction changed?
          if(mc_tabs_parameters_l.subFunction != mc_tabs_parameters.subFunction)
          {
            if(mc_tabs_parameters_l.subFunction == 0) mc_stage_tc_properties.kill = 1;
            if(mc_tabs_parameters_l.subFunction == 1) mc_doors_properties.kill = 1;
            
            if(mc_tabs_parameters.subFunction == 0) mc_stage_tc_properties.run = 1;
            if(mc_tabs_parameters.subFunction == 1) mc_doors_properties.run = 1;
            
            mc_tabs_parameters_l.subFunction = mc_tabs_parameters.subFunction;
          }
      }
      //end B06623 on this tab, we can have 2 different movie clips
      
      
    //******** 
  /*    if (p_TextMedia != (uint8_t*)&mc_cf_parameters.str[0]){
          mc_tabs_parameters.mmText = (uint8_t*)&mc_cf_parameters.str[0];
          mc_tabs_parameters.mmTextUpdate = 1;
          p_TextMedia = (uint8_t*)&mc_cf_parameters.str[0];
      }
*/      if (mc_tabs_parameters.mmTextUpdate){
        switch (mc_tabs_parameters_l.mmTextUpdate){
          case 0:
            //Process the text string. Will return 1 if Ok and 0 if not
            // If 0 then we simply try again
             mc_tabs_parameters_l.mmTextUpdate = ProcessMediaText();
             //mc_tabs_parameters_l.mmTextUpdate = 2;
          break;
          case 1:
            mc_tabs_parameters_l.mmTextUpdate = 2;
          break;
          case 2:
            DrawMedia();
            mc_tabs_parameters_l.mmTextUpdate = 4;
          break;
          case 3:
            //mc_tabs_parameters_l.mmTextUpdate = 4;
          break;
          case 4:
            if (DrawMediaIcon())
              mc_tabs_parameters.mmTextUpdate = mc_tabs_parameters_l.mmTextUpdate = 0; 
          break;
        } // switch (mc_tabs_parameters_l.mmTextUpdate) ...
          
      } // if (mc_tabs_parameters.mmTextUpdate) ...

// Global Parameter logic  **********************
      // if required update the range text
      if (mc_global_tabs.range != mc_global_parameters.range){
        ProcessRangeText();
        DrawRange();
      }
      // Gear selection, scroll animated  
      if(mc_tabs_parameters_l.gear != mc_tabs_parameters.gear){
        setGear();
      }
// Seat belt status    	
      if (mc_tabs_parameters_l.seatBelt.fl != mc_tabs_parameters.seatBelt.fl) 
      {
          SeatBeltUpdate(0, mc_tabs_parameters.seatBelt.fl);
          mc_tabs_parameters_l.seatBelt.fl = mc_tabs_parameters.seatBelt.fl;
      }
      if (mc_tabs_parameters_l.seatBelt.fr != mc_tabs_parameters.seatBelt.fr) 
      {
          SeatBeltUpdate(1, mc_tabs_parameters.seatBelt.fr);
          mc_tabs_parameters_l.seatBelt.fr = mc_tabs_parameters.seatBelt.fr;
      }
      if (mc_tabs_parameters_l.seatBelt.rl != mc_tabs_parameters.seatBelt.rl) 
      {
          SeatBeltUpdate(2, mc_tabs_parameters.seatBelt.rl);
          mc_tabs_parameters_l.seatBelt.rl = mc_tabs_parameters.seatBelt.rl;
      }
      if (mc_tabs_parameters_l.seatBelt.rm != mc_tabs_parameters.seatBelt.rm) 
      {
          SeatBeltUpdate(3, mc_tabs_parameters.seatBelt.rm);
          mc_tabs_parameters_l.seatBelt.rm = mc_tabs_parameters.seatBelt.rm;
      }
      if (mc_tabs_parameters_l.seatBelt.rr != mc_tabs_parameters.seatBelt.rr) 
      {
          SeatBeltUpdate(4, mc_tabs_parameters.seatBelt.rr);
          mc_tabs_parameters_l.seatBelt.rr = mc_tabs_parameters.seatBelt.rr;
      }
     if (mc_tabs_parameters.seatBelt.blink) 
      {
          if(FSLtime.ms > 500) DCU_LayerChromaCfg(TABS_SEATBELT_LAYER) = 1;
          else DCU_LayerChromaCfg(TABS_SEATBELT_LAYER) = 0;  
      /*    mc_tabs_parameters.time.h = FSLtime.m;
          mc_tabs_parameters.time.m = FSLtime.s;
          mc_tabs_parameters.oddo = FSLtime.s * 20;
          mc_tabs_parameters.trip1 = FSLtime.s * 30;
          mc_tabs_parameters.temp = FSLtime.s * 5;
          if(!(FSLtime.ms % 500)) {mc_tabs_parameters.mmTextUpdate = 1;
          mc_tabs_parameters.mmTextCount++;
          if (mc_tabs_parameters.mmTextCount > 30) mc_tabs_parameters.mmTextCount = 0;
          }
          mc_global_parameters.range = FSLtime.s * 11;
          mc_tabs_parameters.gear = (FSLtime.s % 4);;
          mc_tabs_parameters.function = (FSLtime.s % 4);
        */  
      }        

    } //if (relative_fr > 11) ...
    
} //main(){ ...

void transitAnimationB(uint8_t aniNo){
  
  static int32_t colorCurrent = 0, frames_l = 0, accstate1 = 0, accstate2 = 0, speed1 = 0, speed2 = 0;
  uint32_t      temp;
  int32_t       stemp;
  int32_t       Rtemp,Gtemp,Btemp;
  static int32_t       Rt,Gt,Bt,Rs,Gs,Bs,Rd,Gd,Bd, Ad, A;
  
  if (frames_l == 0) {
    frames_l = ani3Data[aniNo].frames;
    speed1 = (ani3Data[aniNo].stop1 - ani3Data[aniNo].start1) / (ani3Data[aniNo].frames - 2);
    speed2 = (ani3Data[aniNo].stop2 - ani3Data[aniNo].start2) / (ani3Data[aniNo].frames - 2);
    Rt = (ani3Data[aniNo].colorTarget & 0xFF0000) >> 16;
    Rs = (ani3Data[aniNo].colorStart & 0xFF0000) >> 16;
    Rd = (Rt - Rs) / (ani3Data[aniNo].frames - 2);
    Gt = (ani3Data[aniNo].colorTarget & 0xFF00) >> 8;
    Gs = (ani3Data[aniNo].colorStart & 0xFF00) >> 8;
    Gd = (Gt - Gs) / (ani3Data[aniNo].frames - 2);
    Bt = (ani3Data[aniNo].colorTarget & 0xFF);
    Bs = (ani3Data[aniNo].colorStart & 0xFF);
    Bd = (Bt - Bs) / (ani3Data[aniNo].frames - 2);
    colorCurrent = ani3Data[aniNo].colorStart; 
    tabsMoving = 1;
    Ad = -0x200 / (ani3Data[aniNo].frames - 2);
    A = 0;
  }  
  frames_l--;
// Shape morph ///////
  switch (accstate1){
    case 0:  //first we advanced with 1/2 of the reminder
      stemp = (ani3Data[aniNo].stop1 - ani3Data[aniNo].start1) % (ani3Data[aniNo].frames - 2);
      DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + (stemp / 2));
      Rtemp = ((Rt - Rs) % Rd) / 2 ; 
      Gtemp = ((Gt - Gs) % Gd) / 2 ; 
      Btemp = ((Bt - Bs) % Bd) / 2 ; 
      colorCurrent = ((colorCurrent & 0xFF0000) + (Rtemp << 16)) + ((colorCurrent & 0xFF00) + (Gtemp << 8)) + ((colorCurrent & 0xFF) + Btemp);
      setColorTabs(colorCurrent);
      accstate1 = 1;              
    break;
    case 1:  //we are at a stready pace
      colorCurrent = ((colorCurrent & 0xFF0000) + (Rd << 16)) + ((colorCurrent & 0xFF00) + (Gd << 8)) + ((colorCurrent & 0xFF) + Bd);
      setColorTabs(colorCurrent);
      DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + speed1);
      A+=Ad;
      if (A <= 5) {
        A = 0;
        Ad *= -1;
        DCU_LayerSetX(TABS_VDL_LAYER2, ani3Data[aniNo].vdlPos);
      }
      else if (A > 0xFF) {
        A = 0xFF;
      }
      DCU_LayerAlpha(TABS_VDL_LAYER2) = A;
      if (frames_l == 1) accstate1 = 2;
    break;
    case 2:  //final position
      DCU_LayerAlpha(TABS_VDL_LAYER2) = 0xFF;
      setColorTabs( ani3Data[aniNo].colorTarget );
      DCU_LayerSetX(TABS_RIGHT_LAYER, ani3Data[aniNo].stop1);
      tabsMoving = 0; // animation is done
      speed1 = 0;
      accstate1 = 0;
    break;
  }
  switch (accstate2){
    case 0:  //first we advanced with 1/2 of the reminder
      stemp = (ani3Data[aniNo].stop2 - ani3Data[aniNo].start2) % (ani3Data[aniNo].frames - 2);
      DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + (stemp / 2));
      accstate2 = 1;              
    break;
    case 1:  //we are at a stready pace
      DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + speed2);
      if (frames_l == 1) accstate2 = 2;
    break;
    case 2:  //final position
      DCU_LayerSetX(TABS_LEFT_LAYER, ani3Data[aniNo].stop2);
      tabsMoving = 0; // animation is done
      speed2 = 0;
      accstate2 = 0;
      frames_l = 0;
    break;
  }
  
  DCU_LayerSetX(TABS_CENTER_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + 32);
  temp = (DCU_LayerGetX(TABS_RIGHT_LAYER) - DCU_LayerGetX(TABS_CENTER_LAYER) + 16);
  temp &=  0xFFFFFFF0;
  DCU_LayerSetWidth(TABS_CENTER_LAYER, temp);
  
// Color morph
    
}

//***************************************/
void transitAnimation(uint8_t aniNo){
  //right 144 to 557 = 413: /16 = 25:13
  //left -33 to 157 = 190 : /16 = 11:14
  // center = left + 32 
  //center Size = INT((right - 16 - left)/ 16) * 16 
  
  static uint8_t frames_l = 0, accdur1 = 0, accdur2 = 0, accstate1 = 0, accstate2 = 0, speed1 = 0, speed2 = 0;
  static int32_t sp_speed1 = 0, sp_speed2 = 0;
  static int32_t progress1 = 0, progress2 = 0, length1, length2; 
  uint32_t i, temp;
  
  if (frames_l == 0) {
    frames_l = ani3Data[aniNo].frames;
    progress1 = 0;
    if (ani3Data[aniNo].acc < 0)length1 = ani3Data[aniNo].start1 - ani3Data[aniNo].stop1;
    else length1 = ani3Data[aniNo].stop1 - ani3Data[aniNo].start1;
    progress2 = 0;
    if (ani3Data[aniNo].acc < 0)length2 = ani3Data[aniNo].start2 - ani3Data[aniNo].stop2;
    else length2 = ani3Data[aniNo].stop2 - ani3Data[aniNo].start2;
    tabsMoving = 1;
    accdur1 = 0;
    accdur2 = 0;
    speed1 = 0;
    speed2 = 0;
  }  
  frames_l--;

  switch (accstate1){
    case 0:  //we are accelerating
      speed1 += ani3Data[aniNo].acc;
      accdur1++;
      progress1 += speed1;
      if (((frames_l - accdur1) * (speed1 + ani3Data[aniNo].acc)) > (length1 - (progress1 * 2))){
        accstate1 = 1;  //switch to steady pace
        sp_speed1 = (length1 - (progress1 * 2)) / ( ani3Data[aniNo].frames - accdur1 - accdur1);
      }
      DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + speed1);
      
    break;
    case 1:  //we are at a stready pace
      progress1 += sp_speed1;
      DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + sp_speed1);
      if (frames_l <= accdur1 + 1) accstate1 = 2;
    break;
    case 2:  //we are deccelerating
      progress1 += speed1;
      for (i=0;i<frames_l;i++) temp += ani3Data[aniNo].acc * i;
      if (temp  > (progress1 - length1))
          DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + speed1 + (temp - speed1));
      else DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + speed1);
      accstate1 = 3;
      speed1 -= ani3Data[aniNo].acc;
    break;
    case 3:
      progress1 += speed1;
      if (frames_l == 0) { 
        DCU_LayerSetX(TABS_RIGHT_LAYER, ani3Data[aniNo].stop1);
        tabsMoving = 0; // animation is done
        speed1 = 0;
        accstate1 = 0;
        break;
      }
      DCU_LayerSetX(TABS_RIGHT_LAYER, DCU_LayerGetX(TABS_RIGHT_LAYER) + speed1);
      speed1 -= ani3Data[aniNo].acc;
    break;
    case 4:
    break;
  }
  switch (accstate2){
    case 0:  //we are accelerating
      speed2 += ani3Data[aniNo].acc;
      accdur2++;
      progress2 += speed2;
      if (((frames_l - accdur2) * (speed2 + ani3Data[aniNo].acc)) > (length2 - (progress2 * 2))){
        accstate2 = 1;  //switch to steady pace
        sp_speed2 = (length2 - (progress2 * 2)) / ( ani3Data[aniNo].frames - accdur2 - accdur2);
      }
      DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + speed2);
      
    break;
    case 1:  //we are at a stready pace
      progress2 += sp_speed2;
      DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + sp_speed2);
      if (frames_l <= accdur2 + 1) accstate2 = 2;
    break;
    case 2:  //we are deccelerating
      progress2 += speed2;
      for (i=0;i<frames_l;i++) temp += ani3Data[aniNo].acc * i;
      if (temp  > (progress2 - length2))
          DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + speed2 + (temp - speed2));
      else DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + speed2);
      accstate2 = 3;
      speed2 -= ani3Data[aniNo].acc;
    break;
    case 3:
      progress2 += speed2;
      if (frames_l == 0) { 
        DCU_LayerSetX(TABS_LEFT_LAYER, ani3Data[aniNo].stop2);
        tabsMoving = 0; // animation is done
        speed2 = 0;
        accstate2 = 0;
        frames_l = 0;
        break;
      }
      DCU_LayerSetX(TABS_LEFT_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + speed2);
      speed2 -= ani3Data[aniNo].acc;
    break;
    case 4:
    break;
  }
  
  DCU_LayerSetX(TABS_CENTER_LAYER, DCU_LayerGetX(TABS_LEFT_LAYER) + 32);
  temp = (DCU_LayerGetX(TABS_RIGHT_LAYER) - DCU_LayerGetX(TABS_CENTER_LAYER) + 16);
  temp &=  0xFFFFFFF0;
  DCU_LayerSetWidth(TABS_CENTER_LAYER, temp);
  
  
    
}
/***************************************************/
void setColorTabs(uint32_t color){

DCU_ForeGroundColor(TABS_CENTER_LAYER) = color;
DCU_ForeGroundColor(TABS_LEFT_LAYER) = color;
DCU_ForeGroundColor(TABS_RIGHT_LAYER) = color;
DCU_ForeGroundColor(TABS_LINE_LAYER) = color;
DCU_ForeGroundColor(TABS_VDL_LAYER) = color;
DCU_ForeGroundColor(TABS_VDL_LAYER2) = color;

}

/***********************************************/
uint8_t ProcessRangeText(void){
  
    int32_t temp32 = 0;
    uint8_t count = 4;
    temp32 = mc_global_parameters.range;
    sRange[0] = ' ';
    sRange[1] = 0x30 + (temp32 / 100);
    temp32 -= (temp32 / 100) * 100;
    sRange[2] = 0x30 + (temp32 / 10);
    sRange[3] = 0x30 + (temp32 % 10);
    if ((sRange[1] == '0') && (sRange[2] == '0')) {
      sRange[2] = sRange[1] = ' '; 
    }
    else if (sRange[1] == '0') sRange[1] = ' ';

    return count;
}
/**********************************************/
/***********************************************/
uint8_t DrawRange(void){
uint8_t dmachnl;
        dmachnl = DMAHR_GetNextFreeChannel();
    	if (dmachnl == DMAHR_NOCHNL) 
    	{
          return 1;  // Failed to draw range due to no free DMA ch.
    	}
        else {
        Font_Print(dmachnl, &tabsText_RAM,(void *)sRange , ProcessRangeText(), (Font_FontType*)&ARIAL30_Font, FONT_ASCII,
          FONT_FREERUN, FONT_HORIZONTAL, FONT_RIGHT, NULL_PTR, 122,12);
          mc_global_tabs.range = mc_global_parameters.range;
          return 0;
        } 
        
}

/***********************************************/
uint8_t ProcessMediaText(void){
  
    int32_t temp32 = 0;
    uint16_t length = 500;
    uint8_t count = mc_tabs_parameters.mmTextCount;
    uint8_t dmachnl;
    
    count++;
    while (length > 340) {
      count--;  
      length = Font_StringWidth((void *) mc_tabs_parameters.mmText, count, (Font_FontType*)&ARIAL30_Font, FONT_ASCII, FONT_DMA);
    }
    //save the count & length for later
    mc_tabs_parameters_l.mmTextCount = count;
    MediaStringLength = length;
    dmachnl = DMAHR_GetNextFreeChannel();
    if (dmachnl == DMAHR_NOCHNL) return 0;    
    Graphics_BlankArea_Rect(dmachnl, &tabsText_RAM, 160, 7, 586, 40, 0x00000000, NULL_PTR);
    
    return 0x1;
}

/***********************************************/
uint8_t tabsPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
){
uint8_t dmachnl;
uint32_t i, length;
        // if count is 0 this is a NULL terminated string and we need to calc the count 
        if (count == 0){
          for(i=0;i<35;i++) 
            if(string[i] == 0) {count = i; break;}
          if (count == 0) return 1;  // there was no NULL termination, and therefore this is an error
        }
        // in case we want to limit the output width, if = 0 we don't
        if (maxWidth){
          count++;
          length = maxWidth + 1;
          while (length > maxWidth) {
            count--;  
            length = Font_StringWidth((void *) string, count, font, FONT_ASCII, FONT_DMA);
          }
        }
        
        dmachnl = DMAHR_GetNextFreeChannel();
    	if (dmachnl == DMAHR_NOCHNL) 
    	{
          return 2;  // Failed to draw range due to no free DMA ch.
    	}
        else {
        Font_Print(dmachnl, target,(void *)string , count, font, FONT_ASCII,
          FONT_FREERUN, FONT_HORIZONTAL, justify, NULL_PTR, xoffset,yoffset);
          return 0;
        }  
}

/**********************************************/
/***********************************************/
uint8_t DrawMedia(void){
uint8_t dmachnl;
        dmachnl = DMAHR_GetNextFreeChannel();
    	if (dmachnl == DMAHR_NOCHNL) 
    	{
          return 1;  // Failed to draw range due to no free DMA ch.
    	}
        else {
        /*tabsPrint(&tabsText_RAM,(void *)mc_tabs_parameters.mmText, (Font_FontType*)&ARIAL30_Font,
          FONT_FREERUN, FONT_HORIZONTAL, FONT_LEFT, NULL_PTR, 400 - (MediaStringLength / 2),12);*/
	tabsPrint(&tabsText_RAM,(void *)mc_tabs_parameters.mmText, (Font_FontType*)&ARIAL30_Font,
                  400 - (MediaStringLength / 2),12, FONT_LEFT, 330, 0);
         
        return 0;
        }  
}

/********************************************/
uint8_t DrawMediaIcon(void){
uint8_t dmachnl, object = 0;
uint16_t x,y;

  
  switch (mc_global_parameters.mmSource){
    case 0:
    case 1:
    case 2:
    case 3:     //Radio
      object = 8;
      x=20;
      y=9;
    break;
    case 4:     //DVD
      object = 0;
      x=40;
      y=15;
    break;
    case 5:     //JukeBox
      object = 2;
      x=32;
      y=8;
    break;
    case 6:     //SD1
      object = 9;
      x=28;
      y=7;
    break;
    case 7:     //SD2
      object = 10;
      x=28;
      y=7;
    break;
    case 8:     //Aux
      object = 1;
      x=32;
      y=8;
    break;
    case 9:     //BT
      object = 11;
      x=24;
      y=8;
    break;

  }
  dmachnl = DMAHR_GetNextFreeChannel();
  // if there is no free DMA channel return 0 
  if (dmachnl == DMAHR_NOCHNL) return 0;
     else{
       Graphics_Paste(
         dmachnl,
         Icons_GObjectArray[object],   
         &tabsText_RAM,
         390 - x - (MediaStringLength / 2),
         y,
         NULL_PTR);
     }
   return 1;  
}
/********************************************/
// The gear graphics is a large image with all the diffrent gear objects stacked vertically.
// We animate the gear selection by modulating the layer address to point to the object we need
void setGear(void){

      if (Display_LayerGetAddress(TABS_GEAR_LAYER) > 
          ((mc_tabs_parameters.gear * Gear_GObjectArray[0]->width * 38) + Gear_GObjectArray[0]->address)){
              Display_LayerSetAddress(TABS_GEAR_LAYER, Display_LayerGetAddress(TABS_GEAR_LAYER) - (Gear_GObjectArray[0]->width * 4));
              //if we overshoot we need to adjust back, no need if the increment is 1 line. But that was to slow
              if (Display_LayerGetAddress(TABS_GEAR_LAYER) < 
                  ((mc_tabs_parameters.gear * Gear_GObjectArray[0]->width * 38) + Gear_GObjectArray[0]->address))
                      Display_LayerSetAddress(TABS_GEAR_LAYER, (mc_tabs_parameters.gear * Gear_GObjectArray[0]->width * 38)+ Gear_GObjectArray[0]->address);
      }        
      else if (Display_LayerGetAddress(TABS_GEAR_LAYER) < 
               ((mc_tabs_parameters.gear * Gear_GObjectArray[0]->width * 38) + Gear_GObjectArray[0]->address)){
              Display_LayerSetAddress(TABS_GEAR_LAYER, Display_LayerGetAddress(TABS_GEAR_LAYER) + (Gear_GObjectArray[0]->width * 4));
              //if we overshoot we need to adjust back
              if (Display_LayerGetAddress(TABS_GEAR_LAYER) > 
                  ((mc_tabs_parameters.gear * Gear_GObjectArray[0]->width * 38) + Gear_GObjectArray[0]->address))
                      Display_LayerSetAddress(TABS_GEAR_LAYER, (mc_tabs_parameters.gear * Gear_GObjectArray[0]->width * 38)+ Gear_GObjectArray[0]->address);
      }        
      else mc_tabs_parameters_l.gear = mc_tabs_parameters.gear;
}

/***************************************************************/

void SeatBeltUpdate(uint8_t seat, uint8_t value)
{
	uint8_t dmachnl;
	dmachnl = DMAHR_GetNextFreeChannel();
	Graphics_Paste(dmachnl,SeatBelt_GObjectArray[value],&tabsSeatBelt_RAM, SeatPos[seat].x,SeatPos[seat].y,NULL_PTR);
}
/********************************************/
void CalculateTime(void){
		sClock[0] = 0x30 + (mc_tabs_parameters.time.h / 10);
		sClock[1] = 0x30 + (mc_tabs_parameters.time.h % 10);
		sClock[3] = 0x30 + (mc_tabs_parameters.time.m / 10);
		sClock[4] = 0x30 + (mc_tabs_parameters.time.m % 10);
		sClock[2] = ':';
}
/********************************************/
uint8_t CalculateTemp(void){
  
    int16_t temp16 = 0;
    uint8_t count = 3;
    
    if (mc_tabs_parameters.temp == 0){
      sTemp[0] = ' ';
      sTemp[1] = ' ';
      sTemp[2] = '0';
      sTemp[3] = '.';
      sTemp[4] = '0';
      return 5;
    }
    
    if (mc_tabs_parameters.temp < 0) {
      temp16 = mc_tabs_parameters.temp * -1;
      sTemp[0] = '-';
    }    
    else { 
      temp16 = mc_tabs_parameters.temp;
      sTemp[0] = '+';
    }

    sTemp[1] = 0x30 + (temp16 / 100);
    temp16 -= (temp16 / 100) * 100;
    sTemp[2] = 0x30 + (temp16 / 10);
    sTemp[4] = 0x30 + (temp16 % 10);
    sTemp[3] = '.';
    count = 5;
    
    if (sTemp[1] == 0x30){
      
      sTemp[5] = sTemp[4];
      sTemp[4] = sTemp[3];
      sTemp[3] = sTemp[2];
      sTemp[2] = sTemp[0];
      sTemp[1] = ' ';
      sTemp[0] = ' ';
      
      //sTemp[1] = sTemp[0];
      //sTemp[0] = ' ';
      //count = 6;
      count = 6;
    }
    return count;
}
/**********************************************/
/***********************************************/
uint8_t CalculateKmTotal(void){
  
    int32_t temp32 = 0;
    uint8_t count = 3;
    if (mc_tabs_parameters.oddo > 9999999) mc_tabs_parameters.oddo = 9999999;
    temp32 = mc_tabs_parameters.oddo;
    sKmTotal[0] = ' ';
    sKmTotal[1] = 0x30 + (temp32 / 1000000);
    temp32 -= (temp32 / 1000000) * 1000000;
    sKmTotal[2] = 0x30 + (temp32 / 100000);
    temp32 -= (temp32 / 100000) * 100000;
    sKmTotal[3] = 0x30 + (temp32 / 10000);
    temp32 -= (temp32 / 10000) * 10000;
    sKmTotal[4] = 0x30 + (temp32 / 1000);
    temp32 -= (temp32 / 1000) * 1000;
    sKmTotal[5] = 0x30 + (temp32 / 100);
    temp32 -= (temp32 / 100) * 100;
    sKmTotal[6] = 0x30 + (temp32 / 10);
    sKmTotal[7] = 0x30 + (temp32 % 10);
    //sKmTotal[3] = '.';
    count = 8;
    if (sKmTotal[1] == 0x30){
      sKmTotal[1] = ' ';
      if (sKmTotal[2] == 0x30){
        sKmTotal[2] = ' ';
        if (sKmTotal[3] == 0x30){
          sKmTotal[3] = ' ';
          if (sKmTotal[4] == 0x30){
            sKmTotal[4] = ' ';
            if (sKmTotal[5] == 0x30){
              sKmTotal[5] = ' ';
              if (sKmTotal[6] == 0x30){
                sKmTotal[6] = ' ';
              }  
            }  
          }
        }  
      }
    }
    
    return count;
}
/**********************************************/
/***********************************************/
uint8_t CalculateKmTrip(uint32_t value){
  
    int32_t temp32 = 0;
    uint8_t count = 3;
    if (value > 999999) value = 999999;
    temp32 = mc_tabs_parameters.trip1;  
    sKmTrip[8] = 0;  // NULL terminated 
    sKmTrip[0] = ' ';
    sKmTrip[1] = 0x30 + (temp32 / 100000);
    temp32 -= (temp32 / 100000) * 100000;
    sKmTrip[2] = 0x30 + (temp32 / 10000);
    temp32 -= (temp32 / 10000) * 10000;
    sKmTrip[3] = 0x30 + (temp32 / 1000);
    temp32 -= (temp32 / 1000) * 1000;
    sKmTrip[4] = 0x30 + (temp32 / 100);
    temp32 -= (temp32 / 100) * 100;
    sKmTrip[5] = 0x30 + (temp32 / 10);
    sKmTrip[7] = 0x30 + (temp32 % 10);
    sKmTrip[6] = '.';
    count = 8;
    if (sKmTrip[1] == 0x30){
      sKmTrip[1] = ' ';
      if (sKmTrip[2] == 0x30){
        sKmTrip[2] = ' ';
        if (sKmTrip[3] == 0x30){
          sKmTrip[3] = ' ';
          if (sKmTrip[4] == 0x30){
            sKmTrip[4] = ' ';
          }
        }  
      }
    }
    

    return count;
}
/**********************************************/
void mc_tabs_Dispose()
{
	
}

void mc_tabs_Refresh()
{

}

